<?php

namespace App\Models\Person;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class BankAccount extends Model 
{

    protected $table = 'bank_account';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function person()
    {
        return $this->belongsTo('App\Models\Person\Person', 'person_id');
    }

}